/*
 generated hardware definitions from hwdef.dat - DO NOT EDIT
*/

#pragma once

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define MHZ (1000U*1000U)
#define KHZ (1000U)


#define AP_SIGNED_FIRMWARE 0

#define HAL_ENABLE_DFU_BOOT FALSE
#define CHIBIOS_BOARD_NAME "omnibusf4pro-one"
// MCU type (ChibiOS define)
#define STM32F4xx_MCUCONF
#define STM32F405_MCUCONF

#define STM32F405xx

// crystal frequency
#define STM32_HSECLK 8000000U

// UART used for stdout (printf)
// MMC via SPI available, enable POSIX filesystem support
#define USE_POSIX

#define HAL_USE_MMC_SPI TRUE
#define HAL_USE_SDC FALSE
#define HAL_SDCARD_SPI_HOOK TRUE
#define STM32_USB_USE_OTG1                  TRUE
#define STM32_OTG2_IS_OTG1                  FALSE
#define HAL_USE_USB TRUE
#define HAL_USE_SERIAL_USB TRUE
#ifndef STM32F4
#define STM32F4 1
#endif
#define HAL_USE_HW_RNG FALSE
#define HAL_PROCESS_STACK_SIZE 0x1C00
#define STM32_ST_USE_TIMER 5
#define BOARD_RSSI_ANA_PIN 0
#define AP_NOTIFY_GPIO_LED_2_ENABLED 1
#define HAL_GPIO_A_LED_PIN 1
#define HAL_GPIO_B_LED_PIN 2
#define AP_BARO_BACKEND_DEFAULT_ENABLED 0
#define ALLOW_ARM_NO_COMPASS
#define HAL_PROBE_EXTERNAL_I2C_COMPASSES
#define HAL_I2C_INTERNAL_MASK 0
#define HAL_COMPASS_AUTO_ROT_DEFAULT 2
#define HAL_STORAGE_SIZE 15360
#define HAL_OS_FATFS_IO 1
#define HAL_BATT_VOLT_PIN 12
#define HAL_BATT_CURR_PIN 11
#define HAL_BATT_VOLT_SCALE 11
#define HAL_BATT_CURR_SCALE 18.2
#define HAL_OSD_TYPE_DEFAULT 1
#define AP_GPS_BACKEND_DEFAULT_ENABLED 0
#define AP_GPS_DRONECAN_ENABLED HAL_ENABLE_DRONECAN_DRIVERS
#define NUM_SERVO_CHANNELS 16
#define AP_CAMERA_BACKEND_DEFAULT_ENABLED 0
#define AP_BATTERY_BACKEND_DEFAULT_ENABLED 0
#define AP_BATTERY_ANALOG_ENABLED 1
#define AP_BATTERY_ESC_ENABLED HAL_WITH_ESC_TELEM
#define AP_BATTERY_UAVCAN_BATTERYINFO_ENABLED HAL_ENABLE_DRONECAN_DRIVERS
#define AP_BATTERY_SMBUS_GENERIC_ENABLED AP_BATTERY_SMBUS_ENABLED
#define AP_BATTERY_SMBUS_NEODESIGN_ENABLED AP_BATTERY_SMBUS_ENABLED
#define AP_BATTERY_SMBUS_SUI_ENABLED AP_BATTERY_SMBUS_ENABLED
#define AP_BATTERY_SMBUS_MAXELL_ENABLED AP_BATTERY_SMBUS_ENABLED
#define AP_BATTERY_SMBUS_ROTOYE_ENABLED AP_BATTERY_SMBUS_ENABLED
#define AP_SCHEDULER_EXTENDED_TASKINFO_ENABLED 0
#define AC_NAV_GUIDED 0
#define WEATHERVANE_ENABLED 0
#define MODE_AUTOROTATE_ENABLED 0
#define AP_AIRSPEED_BACKEND_DEFAULT_ENABLED 0
#define AP_CAMERA_INFO_FROM_SCRIPT_ENABLED 0
#define AP_MAVLINK_MSG_VIDEO_STREAM_INFORMATION_ENABLED 0
#define AP_MOTORS_FRAME_DEFAULT_ENABLED 0
#define HAL_EXTERNAL_AHRS_ENABLED 0
#define AP_EXTERNAL_AHRS_VECTORNAV_ENABLED 0
#define HAL_BARO_WIND_COMP_ENABLED 0
#define HAL_NAVEKF2_AVAILABLE 0
#define HAL_NAVEKF3_AVAILABLE 1
#define EK3_FEATURE_EXTERNAL_NAV 0
#define EK3_FEATURE_OPTFLOW_FUSION 1
#define EK3_FEATURE_DRAG_FUSION 0
#define AP_EXTERNAL_AHRS_INERTIALLABS_ENABLED 0
#define AP_EXTERNAL_AHRS_MICROSTRAIN5_ENABLED 0
#define AP_EXTERNAL_AHRS_MICROSTRAIN7_ENABLED 0
#define HAL_VISUALODOM_ENABLED 0
#define HAL_PERIPH_SUPPORT_LONG_CAN_PRINTF 0
#define AP_FETTEC_ONEWIRE_ENABLED 0
#define AP_DRONECAN_HIMARK_SERVO_SUPPORT 0
#define AP_DRONECAN_HOBBYWING_ESC_SUPPORT 0
#define AP_KDECAN_ENABLED 0
#define AP_ROBOTISSERVO_ENABLED 0
#define AP_SBUSOUTPUT_ENABLED 1
#define AP_VOLZ_ENABLED 0
#define AP_DRONECAN_VOLZ_FEEDBACK_ENABLED 0
#define AP_AIRSPEED_ASP5033_ENABLED 0
#define AP_AIRSPEED_ANALOG_ENABLED 0
#define AP_AIRSPEED_DLVR_ENABLED 0
#define AP_AIRSPEED_DRONECAN_ENABLED 0
#define AP_AIRSPEED_MS4525_ENABLED 0
#define AP_AIRSPEED_MS5525_ENABLED 0
#define AP_AIRSPEED_MSP_ENABLED 0
#define AP_AIRSPEED_NMEA_ENABLED 0
#define AP_AIRSPEED_SDP3X_ENABLED 0
#define AP_BARO_PROBE_EXTERNAL_I2C_BUSES 1
#define AP_TEMPCALIBRATION_ENABLED 1
#define AP_BARO_BMP085_ENABLED 1
#define AP_BARO_BMP280_ENABLED 1
#define AP_BARO_BMP388_ENABLED 0
#define AP_BARO_BMP581_ENABLED 0
#define AP_BARO_DPS280_ENABLED 1
#define AP_BARO_DRONECAN_ENABLED 0
#define AP_BARO_EXTERNALAHRS_ENABLED 0
#define AP_BARO_FBM320_ENABLED 0
#define AP_BARO_KELLERLD_ENABLED 0
#define AP_BARO_LPS2XH_ENABLED 0
#define AP_BARO_MS56XX_ENABLED 0
#define AP_BARO_MSP_ENABLED 1
#define AP_BARO_SPL06_ENABLED 1
#define AP_BATTERY_ESC_TELEM_OUTBOUND_ENABLED 0
#define AP_BATTERY_FUELFLOW_ENABLED 0
#define AP_BATTERY_FUELLEVEL_ANALOG_ENABLED 0
#define AP_BATTERY_FUELLEVEL_PWM_ENABLED 0
#define AP_BATTERY_INA2XX_ENABLED 1
#define AP_BATTERY_SMBUS_ENABLED 0
#define AP_BATTERY_SUM_ENABLED 1
#define AP_BATTERY_SYNTHETIC_CURRENT_ENABLED 1
#define AP_BATTERY_WATT_MAX_ENABLED 1
#define AP_CAMERA_ENABLED 1
#define AP_CAMERA_SEND_FOV_STATUS_ENABLED 0
#define AP_CAMERA_MAVLINK_ENABLED 1
#define AP_CAMERA_MAVLINKCAMV2_ENABLED 0
#define AP_CAMERA_MOUNT_ENABLED 1
#define AP_CAMERA_RELAY_ENABLED 1
#define AP_CAMERA_SERVO_ENABLED 1
#define AP_CAMERA_SOLOGIMBAL_ENABLED 0
#define AP_CAMERA_SEND_THERMAL_RANGE_ENABLED 0
#define HAL_RUNCAM_ENABLED 1
#define AP_COMPASS_AK09916_ENABLED 1
#define AP_COMPASS_AK8963_ENABLED 0
#define AP_COMPASS_BMM150_ENABLED 1
#define AP_COMPASS_BMM350_ENABLED 1
#define COMPASS_LEARN_ENABLED 1
#define AP_COMPASS_DRONECAN_ENABLED 0
#define AP_COMPASS_DRONECAN_HIRES_ENABLED 0
#define AP_COMPASS_EXTERNALAHRS_ENABLED 0
#define AP_COMPASS_CALIBRATION_FIXED_YAW_ENABLED 1
#define AP_COMPASS_HMC5843_ENABLED 1
#define AP_COMPASS_ICM20948_ENABLED 1
#define AP_COMPASS_IST8308_ENABLED 1
#define AP_COMPASS_IST8310_ENABLED 1
#define AP_COMPASS_LIS3MDL_ENABLED 1
#define AP_COMPASS_LSM303D_ENABLED 0
#define AP_COMPASS_LSM9DS1_ENABLED 0
#define AP_COMPASS_MAG3110_ENABLED 0
#define AP_COMPASS_MMC3416_ENABLED 1
#define AP_COMPASS_MMC5XX3_ENABLED 0
#define AP_COMPASS_QMC5883L_ENABLED 1
#define AP_COMPASS_RM3100_ENABLED 1
#define AC_PAYLOAD_PLACE_ENABLED 1
#define MODE_BRAKE_ENABLED 1
#define MODE_FLIP_ENABLED 1
#define MODE_FLOWHOLD_ENABLED 1
#define MODE_FOLLOW_ENABLED 1
#define MODE_GUIDED_NOGPS_ENABLED 0
#define MODE_SPORT_ENABLED 0
#define MODE_SYSTEMID_ENABLED 0
#define MODE_TURTLE_ENABLED 0
#define MODE_ZIGZAG_ENABLED 0
#define AP_CRASHDUMP_ENABLED 0
#define AP_INERTIALSENSOR_KILL_IMU_ENABLED 0
#define HAL_ENABLE_DRONECAN_DRIVERS 0
#define AP_EXTENDED_ESC_TELEM_ENABLED 1
#define HAL_PICCOLO_CAN_ENABLE 0
#define HAL_TORQEEDO_ENABLED 0
#define FORCE_APJ_DEFAULT_PARAMETERS 0
#define AP_FILESYSTEM_MISSION_ENABLED 1
#define AP_FILESYSTEM_PARAM_ENABLED 1
#define AP_FILESYSTEM_ROMFS_ENABLED 1
#define AP_FILESYSTEM_SYS_ENABLED 1
#define AP_DRONECAN_SEND_GPS 0
#define AP_GPS_ERB_ENABLED 0
#define AP_GPS_BLENDED_ENABLED 0
#define AP_GPS_GSOF_ENABLED 0
#define AP_GPS_MAV_ENABLED 0
#define AP_GPS_NMEA_ENABLED 1
#define AP_GPS_NMEA_UNICORE_ENABLED 1
#define AP_GPS_NOVA_ENABLED 0
#define AP_GPS_SBF_ENABLED 0
#define AP_GPS_SBP_ENABLED 0
#define AP_GPS_SBP2_ENABLED 0
#define AP_GPS_SIRF_ENABLED 0
#define AP_GPS_UBLOX_ENABLED 1
#define HAL_GENERATOR_ENABLED 0
#define AP_GENERATOR_IE_2400_ENABLED 0
#define AP_GENERATOR_IE_650_800_ENABLED 0
#define AP_GENERATOR_RICHENPOWER_ENABLED 0
#define HAL_MOUNT_ALEXMOS_ENABLED 1
#define HAL_MOUNT_GREMSY_ENABLED 0
#define HAL_MOUNT_ENABLED 1
#define HAL_MOUNT_SERVO_ENABLED 1
#define HAL_MOUNT_SIYI_ENABLED 1
#define HAL_SOLO_GIMBAL_ENABLED 0
#define HAL_MOUNT_STORM32MAVLINK_ENABLED 1
#define HAL_MOUNT_STORM32SERIAL_ENABLED 1
#define HAL_MOUNT_TOPOTEK_ENABLED 0
#define HAL_MOUNT_VIEWPRO_ENABLED 0
#define HAL_MOUNT_XACTI_ENABLED 0
#define HAL_EFI_ENABLED 0
#define AP_EFI_CURRAWONG_ECU_ENABLED 0
#define AP_EFI_DRONECAN_ENABLED 0
#define AP_EFI_SERIAL_HIRTH_ENABLED 0
#define AP_EFI_SERIAL_LUTAN_ENABLED 0
#define AP_EFI_MAV_ENABLED 0
#define AP_EFI_SERIAL_MS_ENABLED 0
#define AP_EFI_NWPWU_ENABLED 0
#define AP_ICENGINE_ENABLED 0
#define AP_INERTIALSENSOR_BATCHSAMPLER_ENABLED 1
#define AP_INERTIALSENSOR_HARMONICNOTCH_ENABLED 1
#define HAL_INS_TEMPERATURE_CAL_ENABLE 0
#define HAL_ADSB_ENABLED 0
#define HAL_ADSB_SAGETECH_ENABLED 0
#define HAL_ADSB_SAGETECH_MXS_ENABLED 0
#define HAL_ADSB_UAVIONIX_MAVLINK_ENABLED 0
#define HAL_ADSB_UCP_ENABLED 0
#define AP_AIS_ENABLED 0
#define AP_OPENDRONEID_ENABLED 0
#define AP_MAVLINK_BATTERY2_ENABLED 0
#define AP_MAVLINK_FTP_ENABLED 1
#define AC_POLYFENCE_FENCE_POINT_PROTOCOL_SUPPORT 1
#define HAL_HIGH_LATENCY2_ENABLED 0
#define AP_MAVLINK_MSG_MISSION_REQUEST_ENABLED 1
#define AP_MAVLINK_MSG_RC_CHANNELS_RAW_ENABLED 1
#define AP_MAVLINK_AUTOPILOT_VERSION_REQUEST_ENABLED 0
#define AP_MAVLINK_MAV_CMD_SET_HAGL_ENABLED 0
#define AP_MAVLINK_MSG_DEVICE_OP_ENABLED 1
#define AP_MAVLINK_MSG_HIL_GPS_ENABLED 0
#define AP_MAVLINK_MSG_MOUNT_CONFIGURE_ENABLED 0
#define AP_MAVLINK_MSG_MOUNT_CONTROL_ENABLED 0
#define AP_MAVLINK_MSG_RELAY_STATUS_ENABLED 0
#define AP_MAVLINK_MSG_SERIAL_CONTROL_ENABLED 1
#define AP_MAVLINK_SERVO_RELAY_ENABLED 1
#define AP_MAVLINK_RALLY_POINT_PROTOCOL_ENABLED 1
#define AP_MAVLINK_MAV_CMD_REQUEST_AUTOPILOT_CAPABILITIES_ENABLED 1
#define HAL_MSP_ENABLED 1
#define AP_COMPASS_MSP_ENABLED 1
#define HAL_WITH_MSP_DISPLAYPORT 1
#define HAL_MSP_GPS_ENABLED 1
#define HAL_MSP_OPTICALFLOW_ENABLED 1
#define HAL_MSP_RANGEFINDER_ENABLED 1
#define HAL_MSP_SENSORS_ENABLED 1
#define AP_MISSION_NAV_PAYLOAD_PLACE_ENABLED 1
#define AP_NETWORKING_CAN_MCAST_ENABLED 0
#define AP_NETWORKING_BACKEND_PPP 0
#define HAL_DISPLAY_ENABLED 0
#define AP_NOTIFY_MAVLINK_LED_CONTROL_SUPPORT_ENABLED 0
#define AP_NOTIFY_NCP5623_ENABLED 0
#define AP_NOTIFY_NEOPIXEL_ENABLED 1
#define AP_NOTIFY_PROFILED_ENABLED 1
#define AP_NOTIFY_PROFILED_SPI_ENABLED 0
#define AP_NOTIFY_MAVLINK_PLAY_TUNE_SUPPORT_ENABLED 0
#define AP_NOTIFY_TONEALARM_ENABLED 1
#define OSD_ENABLED 1
#define AP_OSD_LINK_STATS_EXTENSIONS_ENABLED 1
#define OSD_PARAM_ENABLED 1
#define HAL_OSD_SIDEBAR_ENABLE 1
#define HAL_PLUSCODE_ENABLE 0
#define AP_BOOTLOADER_FLASHING_ENABLED 1
#define HAL_BUTTON_ENABLED 1
#define COMPASS_CAL_ENABLED 1
#define AP_CUSTOMROTATIONS_ENABLED 1
#define AP_DRONECAN_SERIAL_ENABLED 0
#define HAL_GYROFFT_ENABLED 0
#define HAL_LOGGING_ENABLED 1
#define HAL_NMEA_OUTPUT_ENABLED 0
#define AP_SCRIPTING_ENABLED 0
#define AP_SCRIPTING_SERIALDEVICE_ENABLED 0
#define AP_FILESYSTEM_FORMAT_ENABLED 1
#define AP_SDCARD_STORAGE_ENABLED 1
#define AP_SERIALMANAGER_REGISTER_ENABLED 0
#define AP_CAN_SLCAN_ENABLED 0
#define AP_GRIPPER_ENABLED 1
#define AP_LANDINGGEAR_ENABLED 1
#define AP_RELAY_ENABLED 1
#define AP_SERVORELAYEVENTS_ENABLED 1
#define HAL_SPRAYER_ENABLED 0
#define AP_WINCH_ENABLED 0
#define AP_WINCH_DAIWA_ENABLED 0
#define AP_WINCH_PWM_ENABLED 0
#define AP_ADVANCEDFAILSAFE_ENABLED 1
#define AP_TUNING_ENABLED 1
#define HAL_LANDING_DEEPSTALL_ENABLED 0
#define AP_PLANE_BLACKBOX_LOGGING 0
#define AP_PLANE_GLIDER_PULLUP_ENABLED 0
#define AP_PLANE_OFFBOARD_GUIDED_SLEW_ENABLED 0
#define QAUTOTUNE_ENABLED 0
#define HAL_QUADPLANE_ENABLED 0
#define HAL_SOARING_ENABLED 0
#define AC_PRECLAND_ENABLED 0
#define AC_PRECLAND_COMPANION_ENABLED 0
#define AC_PRECLAND_IRLOCK_ENABLED 0
#define HAL_PROXIMITY_ENABLED 0
#define AP_PROXIMITY_CYGBOT_ENABLED 0
#define AP_PROXIMITY_DRONECAN_ENABLED 0
#define AP_PROXIMITY_LIGHTWARE_SF40C_ENABLED 0
#define AP_PROXIMITY_LIGHTWARE_SF45B_ENABLED 0
#define AP_PROXIMITY_MAV_ENABLED 0
#define AP_PROXIMITY_RANGEFINDER_ENABLED 0
#define AP_PROXIMITY_RPLIDARA2_ENABLED 0
#define AP_PROXIMITY_TERARANGERTOWER_ENABLED 0
#define AP_PROXIMITY_TERARANGERTOWEREVO_ENABLED 0
#define AP_RCPROTOCOL_CRSF_ENABLED 1
#define AP_RCPROTOCOL_GHST_ENABLED 0
#define AP_RCPROTOCOL_IBUS_ENABLED 0
#define AP_RCPROTOCOL_MAVLINK_RADIO_ENABLED 1
#define AP_RCPROTOCOL_PPMSUM_ENABLED 1
#define AP_RCPROTOCOL_ENABLED 1
#define AP_RCPROTOCOL_SBUS_ENABLED 1
#define AP_RCPROTOCOL_SRXL_ENABLED 0
#define AP_RCPROTOCOL_SRXL2_ENABLED 0
#define AP_RCPROTOCOL_ST24_ENABLED 0
#define AP_RCPROTOCOL_SUMD_ENABLED 0
#define AP_RSSI_ENABLED 1
#define AP_RANGEFINDER_ENABLED 1
#define AP_RANGEFINDER_ANALOG_ENABLED 1
#define AP_RANGEFINDER_BENEWAKE_CAN_ENABLED 0
#define AP_RANGEFINDER_BENEWAKE_TF02_ENABLED 1
#define AP_RANGEFINDER_BENEWAKE_TF03_ENABLED 1
#define AP_RANGEFINDER_BLPING_ENABLED 0
#define AP_RANGEFINDER_DRONECAN_ENABLED 0
#define AP_RANGEFINDER_GYUS42V2_ENABLED 0
#define AP_RANGEFINDER_HC_SR04_ENABLED 1
#define AP_RANGEFINDER_JRE_SERIAL_ENABLED 0
#define AP_RANGEFINDER_LANBAO_ENABLED 0
#define AP_RANGEFINDER_LEDDARONE_ENABLED 0
#define AP_RANGEFINDER_LEDDARVU8_ENABLED 0
#define AP_RANGEFINDER_LIGHTWARE_SERIAL_ENABLED 0
#define AP_RANGEFINDER_LUA_ENABLED 0
#define AP_RANGEFINDER_LWI2C_ENABLED 0
#define AP_RANGEFINDER_MAVLINK_ENABLED 1
#define AP_RANGEFINDER_MAXBOTIX_SERIAL_ENABLED 0
#define AP_RANGEFINDER_MAXSONARI2CXL_ENABLED 0
#define AP_RANGEFINDER_NMEA_ENABLED 0
#define AP_RANGEFINDER_NOOPLOOP_ENABLED 0
#define AP_RANGEFINDER_NRA24_CAN_ENABLED 0
#define AP_RANGEFINDER_PULSEDLIGHTLRF_ENABLED 1
#define AP_RANGEFINDER_PWM_ENABLED 1
#define AP_RANGEFINDER_RDS02UF_ENABLED 0
#define AP_RANGEFINDER_TOFSENSEF_I2C_ENABLED 0
#define AP_RANGEFINDER_TOFSENSEP_CAN_ENABLED 0
#define AP_RANGEFINDER_TRI2C_ENABLED 0
#define AP_RANGEFINDER_TERARANGER_SERIAL_ENABLED 0
#define AP_RANGEFINDER_USD1_CAN_ENABLED 0
#define AP_RANGEFINDER_USD1_SERIAL_ENABLED 0
#define AP_RANGEFINDER_VL53L0X_ENABLED 1
#define AP_RANGEFINDER_VL53L1X_ENABLED 1
#define AP_RANGEFINDER_WASP_ENABLED 1
#define AP_RANGEFINDER_BENEWAKE_TFMINI_ENABLED 1
#define AP_RANGEFINDER_BENEWAKE_TFMINIPLUS_ENABLED 1
#define AP_ROVER_ADVANCED_FAILSAFE_ENABLED 0
#define AP_AVOIDANCE_ENABLED 1
#define AP_OAPATHPLANNER_ENABLED 0
#define AP_FENCE_ENABLED 1
#define HAL_PARACHUTE_ENABLED 1
#define HAL_RALLY_ENABLED 1
#define AP_AIRSPEED_ENABLED 1
#define AP_BEACON_ENABLED 0
#define GPS_MOVING_BASELINE 1
#define AP_SERIALMANAGER_IMUOUT_ENABLED 0
#define AP_OPTICALFLOW_ENABLED 1
#define AP_OPTICALFLOW_CXOF_ENABLED 0
#define AP_OPTICALFLOW_HEREFLOW_ENABLED 0
#define AP_OPTICALFLOW_MAV_ENABLED 1
#define AP_OPTICALFLOW_ONBOARD_ENABLED 1
#define AP_OPTICALFLOW_PIXART_ENABLED 0
#define AP_OPTICALFLOW_PX4FLOW_ENABLED 0
#define AP_OPTICALFLOW_UPFLOW_ENABLED 0
#define AP_RPM_ENABLED 1
#define AP_RPM_DRONECAN_ENABLED 0
#define AP_RPM_EFI_ENABLED 0
#define AP_RPM_ESC_TELEM_ENABLED 1
#define AP_RPM_GENERATOR_ENABLED 0
#define AP_RPM_HARMONICNOTCH_ENABLED 1
#define AP_RPM_PIN_ENABLED 1
#define AP_TEMPERATURE_SENSOR_ENABLED 1
#define AP_TEMPERATURE_SENSOR_MCP9600_ENABLED 1
#define AP_TEMPERATURE_SENSOR_MLX90614_ENABLED 1
#define AP_TEMPERATURE_SENSOR_TSYS01_ENABLED 1
#define AP_TEMPERATURE_SENSOR_TSYS03_ENABLED 1
#define AP_RC_CHANNEL_AUX_FUNCTION_STRINGS_ENABLED 0
#define HAL_WITH_FRSKY_TELEM_BIDIRECTIONAL 1
#define HAL_CRSF_TELEM_ENABLED 1
#define HAL_CRSF_TELEM_TEXT_SELECTION_ENABLED 1
#define AP_FRSKY_TELEM_ENABLED 1
#define AP_FRSKY_D_TELEM_ENABLED 1
#define AP_FRSKY_SPORT_TELEM_ENABLED 1
#define AP_FRSKY_SPORT_PASSTHROUGH_ENABLED 1
#define AP_GHST_TELEM_ENABLED 0
#define HAL_HOTT_TELEM_ENABLED 0
#define AP_LTM_TELEM_ENABLED 1
#define HAL_SPEKTRUM_TELEM_ENABLED 0
#define AP_IBUS_TELEM_ENABLED 0
#define AP_MOTORS_FRAME_DECA_ENABLED 0
#define AP_MOTORS_FRAME_DODECAHEXA_ENABLED 0
#define AP_MOTORS_FRAME_HEXA_ENABLED 1
#define AP_MOTORS_FRAME_OCTA_ENABLED 0
#define AP_MOTORS_FRAME_OCTAQUAD_ENABLED 0
#define AP_MOTORS_FRAME_QUAD_ENABLED 1
#define AP_MOTORS_FRAME_Y6_ENABLED 0
#define AP_SMARTAUDIO_ENABLED 1
#define AP_TRAMP_ENABLED 1
#define AP_VIDEOTX_ENABLED 1
#define HAL_MOUNT_CADDX_ENABLED 1
#define HAL_COMPASS_MAX_SENSORS 1
#define GPS_MAX_RECEIVERS 1
#define GPS_MAX_INSTANCES 1
#define AP_BOOTLOADER_FLASHING_ENABLED 0
#define BOARD_FLASH_SIZE 1024

// location of loaded firmware
#define FLASH_LOAD_ADDRESS 0x08010000
#define EXT_FLASH_SIZE_MB 0
#define EXT_FLASH_RESERVE_START_KB 0
#define EXT_FLASH_RESERVE_END_KB 0
#define CRT0_AREAS_NUMBER 1
#define __EXTFLASHFUNC__
#define STORAGE_FLASH_PAGE 1
#ifndef AP_CRASHDUMP_ENABLED
#define AP_CRASHDUMP_ENABLED 0
#endif

#define HAL_RAM0_START 0x20000000
// memory regions
#define HAL_MEMORY_REGIONS {(void*)0x20000000, 0x00020000, 0x01 }, {(void*)0x10000000, 0x00010000, 0x02 }
#define HAL_CC_MEMORY_REGIONS {0x20000000, 0x20020000, CRASH_CATCHER_BYTE }, {0x10000000, 0x10010000, CRASH_CATCHER_BYTE }
#define HAL_MEMORY_TOTAL_KB 192

// CPU serial number (12 bytes)
#define UDID_START UID_BASE


// APJ board ID (for bootloaders)
#define APJ_BOARD_ID 131

#ifndef HAL_ENABLE_THREAD_STATISTICS
#define HAL_ENABLE_THREAD_STATISTICS FALSE
#endif
    
#ifndef HAL_HAVE_HARDWARE_DOUBLE
#define HAL_HAVE_HARDWARE_DOUBLE 0
#endif
#define HAL_EXPECTED_SYSCLOCK 168000000
#define STM32_DMA_REQUIRED TRUE


#ifndef HAL_FLASH_PROTECTION
#define HAL_FLASH_PROTECTION 0
#endif
#define HAL_SPI1_CONFIG { &SPID1, 1, STM32_SPI_SPI1_DMA_STREAMS, PAL_LINE(GPIOA,5U) }
#define HAL_SPI2_CONFIG { &SPID2, 2, STM32_SPI_SPI2_DMA_STREAMS, PAL_LINE(GPIOB,13U) }
#define HAL_SPI3_CONFIG { &SPID3, 3, STM32_SPI_SPI3_DMA_STREAMS, PAL_LINE(GPIOC,10U) }
#define HAL_SPI_BUS_LIST HAL_SPI1_CONFIG,HAL_SPI2_CONFIG,HAL_SPI3_CONFIG


// SPI device table
#define HAL_SPI_DEVICE0  SPIDesc("bmi270"         ,  0,  1, PAL_LINE(GPIOA,4U) , SPIDEV_MODE3,   1*MHZ,  10*MHZ)
#define HAL_SPI_DEVICE1  SPIDesc("mpu6000"        ,  0,  1, PAL_LINE(GPIOA,4U) , SPIDEV_MODE3,   1*MHZ,   8*MHZ)
#define HAL_SPI_DEVICE2  SPIDesc("sdcard"         ,  1,  2, PAL_LINE(GPIOB,12U), SPIDEV_MODE0, 400*KHZ,  25*MHZ)
#define HAL_SPI_DEVICE3  SPIDesc("bmp280"         ,  2,  3, PAL_LINE(GPIOB,3U) , SPIDEV_MODE3,   1*MHZ,   8*MHZ)
#define HAL_SPI_DEVICE4  SPIDesc("osd"            ,  2,  4, PAL_LINE(GPIOA,15U), SPIDEV_MODE0,  10*MHZ,  10*MHZ)
#define HAL_SPI_DEVICE_LIST HAL_SPI_DEVICE0,HAL_SPI_DEVICE1,HAL_SPI_DEVICE2,HAL_SPI_DEVICE3,HAL_SPI_DEVICE4

#define HAL_WITH_SPI_BMI270 1
#define HAL_WITH_SPI_MPU6000 1
#define HAL_WITH_SPI_SDCARD 1
#define HAL_WITH_SPI_BMP280 1
#define HAL_WITH_SPI_OSD 1

// ADC config
#define HAL_ANALOG_PINS \
{  0,  0,    3.30/4096 }, /* PA0 RSSI_IN */ \
{ 11, 11,    3.30/4096 }, /* PC1 BAT_CURR_SENS */ \
{ 12, 12,    3.30/4096 }, /* PC2 BAT_VOLT_SENS */ \


// GPIO config
#define HAL_GPIO_LINE_GPIO1 PAL_LINE(GPIOB,5U)
#define HAL_GPIO_LINE_GPIO50 PAL_LINE(GPIOB,0U)
#define HAL_GPIO_LINE_GPIO51 PAL_LINE(GPIOB,1U)
#define HAL_GPIO_LINE_GPIO52 PAL_LINE(GPIOA,3U)
#define HAL_GPIO_LINE_GPIO53 PAL_LINE(GPIOA,2U)
#define HAL_GPIO_LINE_GPIO54 PAL_LINE(GPIOA,1U)
#define HAL_GPIO_LINE_GPIO55 PAL_LINE(GPIOA,8U)
#define HAL_GPIO_LINE_GPIO56 PAL_LINE(GPIOC,8U)
#define HAL_GPIO_LINE_GPIO58 PAL_LINE(GPIOB,4U)
#define HAL_GPIO_LINE_GPIO59 PAL_LINE(GPIOC,9U)
#define HAL_GPIO_LINE_GPIO70 PAL_LINE(GPIOB,6U)
#define HAL_GPIO_PINS { \
{   1, true,  0, PAL_LINE(GPIOB,5U)}, /* PB5 LED_BLUE OUTPUT */ \
{  50, true,  1, PAL_LINE(GPIOB,0U)}, /* PB0 TIM1_CH2N TIM1 AF1 PWM1 */ \
{  51, true,  2, PAL_LINE(GPIOB,1U)}, /* PB1 TIM1_CH3N TIM1 AF1 PWM2 */ \
{  52, true,  3, PAL_LINE(GPIOA,3U)}, /* PA3 TIM2_CH4 TIM2 AF1 PWM3 */ \
{  53, true,  4, PAL_LINE(GPIOA,2U)}, /* PA2 TIM2_CH3 TIM2 AF1 PWM4 */ \
{  54, true,  5, PAL_LINE(GPIOA,1U)}, /* PA1 TIM2_CH2 TIM2 AF1 PWM5 */ \
{  55, true,  6, PAL_LINE(GPIOA,8U)}, /* PA8 TIM1_CH1 TIM1 AF1 PWM6 */ \
{  56, true,  7, PAL_LINE(GPIOC,8U)}, /* PC8 TIM8_CH3 TIM8 AF3 PWM7 */ \
{  58, true,  0, PAL_LINE(GPIOB,4U)}, /* PB4 TIM3_CH1 TIM3 AF2 */ \
{  59, true,  8, PAL_LINE(GPIOC,9U)}, /* PC9 TIM8_CH4 TIM8 AF3 PWM8 */ \
{  70, true,  0, PAL_LINE(GPIOB,6U)}, /* PB6 GP_GPIO OUTPUT */ \
}

// full pin define list
#define HAL_GPIO_PIN_BAT_CURR_SENS        PAL_LINE(GPIOC,1U)
#define HAL_GPIO_PIN_BAT_VOLT_SENS        PAL_LINE(GPIOC,2U)
#define HAL_GPIO_PIN_BMP280_CS            PAL_LINE(GPIOB,3U)
#define HAL_GPIO_PIN_GP_GPIO              PAL_LINE(GPIOB,6U)
#define HAL_GPIO_PIN_I2C2_SCL             PAL_LINE(GPIOB,10U)
#define HAL_GPIO_PIN_I2C2_SDA             PAL_LINE(GPIOB,11U)
#define HAL_GPIO_PIN_I2C2_SCL             PAL_LINE(GPIOB,10U)
#define HAL_GPIO_PIN_JTCK_SWCLK           PAL_LINE(GPIOA,14U)
#define HAL_GPIO_PIN_JTMS_SWDIO           PAL_LINE(GPIOA,13U)
#define HAL_GPIO_PIN_LED_BLUE             PAL_LINE(GPIOB,5U)
#define HAL_GPIO_PIN_MPU6000_CS           PAL_LINE(GPIOA,4U)
#define HAL_GPIO_PIN_OSD_CS               PAL_LINE(GPIOA,15U)
#define HAL_GPIO_PIN_OTG_FS_DM            PAL_LINE(GPIOA,11U)
#define HAL_GPIO_PIN_OTG_FS_DP            PAL_LINE(GPIOA,12U)
#define HAL_GPIO_PIN_RSSI_IN              PAL_LINE(GPIOA,0U)
#define HAL_GPIO_PIN_SDCARD_CS            PAL_LINE(GPIOB,12U)
#define HAL_GPIO_PIN_SPI1_MISO            PAL_LINE(GPIOA,6U)
#define HAL_GPIO_PIN_SPI1_MOSI            PAL_LINE(GPIOA,7U)
#define HAL_GPIO_PIN_SPI1_SCK             PAL_LINE(GPIOA,5U)
#define HAL_GPIO_PIN_SPI2_MISO            PAL_LINE(GPIOB,14U)
#define HAL_GPIO_PIN_SPI2_MOSI            PAL_LINE(GPIOB,15U)
#define HAL_GPIO_PIN_SPI2_SCK             PAL_LINE(GPIOB,13U)
#define HAL_GPIO_PIN_SPI2_MOSI            PAL_LINE(GPIOB,15U)
#define HAL_GPIO_PIN_SPI3_MISO            PAL_LINE(GPIOC,11U)
#define HAL_GPIO_PIN_SPI3_MOSI            PAL_LINE(GPIOC,12U)
#define HAL_GPIO_PIN_SPI3_SCK             PAL_LINE(GPIOC,10U)
#define HAL_GPIO_PIN_SPI3_MOSI            PAL_LINE(GPIOC,12U)
#define HAL_GPIO_PIN_TIM1_CH1             PAL_LINE(GPIOA,8U)
#define HAL_GPIO_PIN_TIM1_CH2N            PAL_LINE(GPIOB,0U)
#define HAL_GPIO_PIN_TIM1_CH3N            PAL_LINE(GPIOB,1U)
#define HAL_GPIO_PIN_TIM2_CH2             PAL_LINE(GPIOA,1U)
#define HAL_GPIO_PIN_TIM2_CH3             PAL_LINE(GPIOA,2U)
#define HAL_GPIO_PIN_TIM2_CH4             PAL_LINE(GPIOA,3U)
#define HAL_GPIO_PIN_TIM3_CH1             PAL_LINE(GPIOB,4U)
#define HAL_GPIO_PIN_TIM4_CH3             PAL_LINE(GPIOB,8U)
#define HAL_GPIO_PIN_TIM8_CH3             PAL_LINE(GPIOC,8U)
#define HAL_GPIO_PIN_TIM8_CH4             PAL_LINE(GPIOC,9U)
#define HAL_GPIO_PIN_USART1_RX            PAL_LINE(GPIOA,10U)
#define HAL_GPIO_PIN_USART1_TX            PAL_LINE(GPIOA,9U)
#define HAL_GPIO_PIN_USART6_RX            PAL_LINE(GPIOC,7U)
#define HAL_GPIO_PIN_USART6_TX            PAL_LINE(GPIOC,6U)
#define HAL_GPIO_PIN_VBUS                 PAL_LINE(GPIOC,5U)

#define HAL_INS_PROBE1  ADD_BACKEND(AP_InertialSensor_Invensense::probe(*this,hal.spi->get_device("mpu6000"),ROTATION_YAW_180))
#define HAL_INS_PROBE2  ADD_BACKEND(AP_InertialSensor_BMI270::probe(*this,hal.spi->get_device("bmi270"),ROTATION_ROLL_180))
#define INS_MAX_INSTANCES 2
#define HAL_INS_PROBE_LIST HAL_INS_PROBE1;HAL_INS_PROBE2

#define HAL_BARO_PROBE1  ADD_BACKEND(AP_Baro_BMP280::probe(*this,hal.spi->get_device("bmp280")))
#define HAL_BARO_PROBE_LIST HAL_BARO_PROBE1

// peripherals enabled
#define STM32_I2C_USE_I2C2                  TRUE
#define STM32_SPI_USE_SPI1                  TRUE
#define STM32_SPI_USE_SPI2                  TRUE
#define STM32_SPI_USE_SPI3                  TRUE
#ifndef STM32_SERIAL_USE_UART4 
#define STM32_SERIAL_USE_UART4  TRUE
#endif
#ifndef STM32_SERIAL_USE_USART1
#define STM32_SERIAL_USE_USART1 TRUE
#endif
#ifndef STM32_SERIAL_USE_USART3
#define STM32_SERIAL_USE_USART3 TRUE
#endif
#ifndef STM32_SERIAL_USE_USART6
#define STM32_SERIAL_USE_USART6 TRUE
#endif
#define AP_PARAM_DEFAULTS_FILE_PARSING_ENABLED 0


// auto-generated DMA mapping from dma_resolver.py

// Note: The following peripherals can't be resolved for DMA: ['USART6_RX', 'USART3_RX', 'UART4_RX']

#define STM32_ADC_ADC1_DMA_STREAM      STM32_DMA_STREAM_ID(2, 4)
#define STM32_ADC_ADC1_DMA_CHAN        0
#define STM32_I2C_I2C2_RX_DMA_STREAM   STM32_DMA_STREAM_ID(1, 2)
#define STM32_I2C_I2C2_RX_DMA_CHAN     7
#define STM32_I2C_I2C2_TX_DMA_STREAM   STM32_DMA_STREAM_ID(1, 7)
#define STM32_I2C_I2C2_TX_DMA_CHAN     7
#define STM32_SPI_SPI1_RX_DMA_STREAM   STM32_DMA_STREAM_ID(2, 0)
#define STM32_SPI_SPI1_RX_DMA_CHAN     3
#define STM32_SPI_SPI1_TX_DMA_STREAM   STM32_DMA_STREAM_ID(2, 3)
#define STM32_SPI_SPI1_TX_DMA_CHAN     3
#define STM32_SPI_SPI2_RX_DMA_STREAM   STM32_DMA_STREAM_ID(1, 3)
#define STM32_SPI_SPI2_RX_DMA_CHAN     0
#define STM32_SPI_SPI2_TX_DMA_STREAM   STM32_DMA_STREAM_ID(1, 4) // shared SPI2_TX,USART3_TX,UART4_TX
#define STM32_SPI_SPI2_TX_DMA_CHAN     0
#define STM32_SPI_SPI3_RX_DMA_STREAM   STM32_DMA_STREAM_ID(1, 0)
#define STM32_SPI_SPI3_RX_DMA_CHAN     0
#define STM32_SPI_SPI3_TX_DMA_STREAM   STM32_DMA_STREAM_ID(1, 5)
#define STM32_SPI_SPI3_TX_DMA_CHAN     0
#define STM32_TIM_TIM1_UP_DMA_STREAM   STM32_DMA_STREAM_ID(2, 5)
#define STM32_TIM_TIM1_UP_DMA_CHAN     6
#define STM32_TIM_TIM2_UP_DMA_STREAM   STM32_DMA_STREAM_ID(1, 1)
#define STM32_TIM_TIM2_UP_DMA_CHAN     3
#define STM32_TIM_TIM8_UP_DMA_STREAM   STM32_DMA_STREAM_ID(2, 1)
#define STM32_TIM_TIM8_UP_DMA_CHAN     7
#define STM32_UART_UART4_TX_DMA_STREAM STM32_DMA_STREAM_ID(1, 4) // shared SPI2_TX,USART3_TX,UART4_TX
#define STM32_UART_UART4_TX_DMA_CHAN   4
#define STM32_UART_USART1_RX_DMA_STREAM STM32_DMA_STREAM_ID(2, 2)
#define STM32_UART_USART1_RX_DMA_CHAN  4
#define STM32_UART_USART1_TX_DMA_STREAM STM32_DMA_STREAM_ID(2, 7)
#define STM32_UART_USART1_TX_DMA_CHAN  4
#define STM32_UART_USART3_TX_DMA_STREAM STM32_DMA_STREAM_ID(1, 4) // shared SPI2_TX,USART3_TX,UART4_TX
#define STM32_UART_USART3_TX_DMA_CHAN  7
#define STM32_UART_USART6_TX_DMA_STREAM STM32_DMA_STREAM_ID(2, 6)
#define STM32_UART_USART6_TX_DMA_CHAN  5

// Mask of DMA streams which are shared
#define SHARED_DMA_MASK ((1U<<STM32_DMA_STREAM_ID(1,4)))


// generated UART DMA configuration lines
#define STM32_USART1_RX_DMA_CONFIG true, STM32_UART_USART1_RX_DMA_STREAM, STM32_UART_USART1_RX_DMA_CHAN
#define STM32_USART1_TX_DMA_CONFIG true, STM32_UART_USART1_TX_DMA_STREAM, STM32_UART_USART1_TX_DMA_CHAN
#define STM32_USART3_RX_DMA_CONFIG false, 0, 0
#define STM32_USART3_TX_DMA_CONFIG true, STM32_UART_USART3_TX_DMA_STREAM, STM32_UART_USART3_TX_DMA_CHAN
#define STM32_UART4_RX_DMA_CONFIG false, 0, 0
#define STM32_UART4_TX_DMA_CONFIG true, STM32_UART_UART4_TX_DMA_STREAM, STM32_UART_UART4_TX_DMA_CHAN
#define STM32_USART6_RX_DMA_CONFIG false, 0, 0
#define STM32_USART6_TX_DMA_CONFIG true, STM32_UART_USART6_TX_DMA_STREAM, STM32_UART_USART6_TX_DMA_CHAN


// generated SPI DMA configuration lines
#define STM32_SPI_SPI1_DMA_STREAMS STM32_SPI_SPI1_TX_DMA_STREAM, STM32_SPI_SPI1_RX_DMA_STREAM
#define STM32_SPI_SPI2_DMA_STREAMS STM32_SPI_SPI2_TX_DMA_STREAM, STM32_SPI_SPI2_RX_DMA_STREAM
#define STM32_SPI_SPI3_DMA_STREAMS STM32_SPI_SPI3_TX_DMA_STREAM, STM32_SPI_SPI3_RX_DMA_STREAM
#define HAL_PWM_COUNT 8
// RC input config
#define HAL_USE_EICU TRUE
#define STM32_EICU_USE_TIM4 TRUE
#define RCININT_EICU_TIMER EICUD4
#define RCININT_EICU_CHANNEL EICU_CHANNEL_3


// Alarm PWM output config
#define STM32_PWM_USE_TIM3 TRUE
#define STM32_TIM3_SUPPRESS_ISR
#define HAL_PWM_ALARM \
        { /* pwmGroup */ \
          0,  /* Timer channel */ \
          { /* PWMConfig */ \
            1000000,    /* PWM clock frequency. */ \
            1000,    /* Initial PWM period 20ms. */ \
            NULL,  /* no callback */ \
            { /* Channel Config */ \
             {PWM_OUTPUT_ACTIVE_HIGH, NULL}, \
             {PWM_OUTPUT_DISABLED, NULL}, \
             {PWM_OUTPUT_DISABLED, NULL}, \
             {PWM_OUTPUT_DISABLED, NULL}  \
            }, \
            0, 0 \
          }, \
          &PWMD3 /* PWMDriver* */ \
        }

// PWM timer config
#define STM32_PWM_USE_TIM2 TRUE
#define STM32_TIM2_SUPPRESS_ISR
#define STM32_PWM_USE_TIM8 TRUE
#define STM32_TIM8_SUPPRESS_ISR
#define STM32_PWM_USE_TIM1 TRUE
#define STM32_TIM1_SUPPRESS_ISR

// PWM output config
#if defined(STM32_TIM_TIM2_UP_DMA_STREAM) && defined(STM32_TIM_TIM2_UP_DMA_CHAN)
# define HAL_PWM2_DMA_CONFIG true, STM32_TIM_TIM2_UP_DMA_STREAM, STM32_TIM_TIM2_UP_DMA_CHAN
#else
# define HAL_PWM2_DMA_CONFIG false, 0, 0
#endif
#if !defined(HAL_TIM2_UP_SHARED)
#define HAL_TIM2_UP_SHARED false
#endif
#define HAL_PWM_GROUP1 { false, \
        {255, 4, 3, 2}, \
        /* Group Initial Config */ \
        { \
          1000000,  /* PWM clock frequency. */ \
          20000,   /* Initial PWM period 20ms. */ \
          NULL,     /* no callback */ \
          { \
           /* Channel Config */ \
           {PWM_OUTPUT_DISABLED, NULL}, \
           {PWM_OUTPUT_ACTIVE_HIGH, NULL}, \
           {PWM_OUTPUT_ACTIVE_HIGH, NULL}, \
           {PWM_OUTPUT_ACTIVE_HIGH, NULL}  \
          }, 0, 0}, &PWMD2, 2, \
          HAL_PWM2_DMA_CONFIG, \
          { 0, 1, 1, 1 }, \
          { 0, PAL_LINE(GPIOA,1U), PAL_LINE(GPIOA,2U), PAL_LINE(GPIOA,3U) }}
#if defined(STM32_TIM_TIM8_UP_DMA_STREAM) && defined(STM32_TIM_TIM8_UP_DMA_CHAN)
# define HAL_PWM8_DMA_CONFIG true, STM32_TIM_TIM8_UP_DMA_STREAM, STM32_TIM_TIM8_UP_DMA_CHAN
#else
# define HAL_PWM8_DMA_CONFIG false, 0, 0
#endif
#if !defined(HAL_TIM8_UP_SHARED)
#define HAL_TIM8_UP_SHARED false
#endif
#define HAL_PWM_GROUP2 { true, \
        {255, 255, 6, 7}, \
        /* Group Initial Config */ \
        { \
          1000000,  /* PWM clock frequency. */ \
          20000,   /* Initial PWM period 20ms. */ \
          NULL,     /* no callback */ \
          { \
           /* Channel Config */ \
           {PWM_OUTPUT_DISABLED, NULL}, \
           {PWM_OUTPUT_DISABLED, NULL}, \
           {PWM_OUTPUT_ACTIVE_HIGH, NULL}, \
           {PWM_OUTPUT_ACTIVE_HIGH, NULL}  \
          }, 0, 0}, &PWMD8, 8, \
          HAL_PWM8_DMA_CONFIG, \
          { 0, 0, 3, 3 }, \
          { 0, 0, PAL_LINE(GPIOC,8U), PAL_LINE(GPIOC,9U) }}
#if defined(STM32_TIM_TIM1_UP_DMA_STREAM) && defined(STM32_TIM_TIM1_UP_DMA_CHAN)
# define HAL_PWM1_DMA_CONFIG true, STM32_TIM_TIM1_UP_DMA_STREAM, STM32_TIM_TIM1_UP_DMA_CHAN
#else
# define HAL_PWM1_DMA_CONFIG false, 0, 0
#endif
#if !defined(HAL_TIM1_UP_SHARED)
#define HAL_TIM1_UP_SHARED false
#endif
#define HAL_PWM_GROUP3 { true, \
        {5, 0, 1, 255}, \
        /* Group Initial Config */ \
        { \
          1000000,  /* PWM clock frequency. */ \
          20000,   /* Initial PWM period 20ms. */ \
          NULL,     /* no callback */ \
          { \
           /* Channel Config */ \
           {PWM_OUTPUT_ACTIVE_HIGH, NULL}, \
           {PWM_COMPLEMENTARY_OUTPUT_ACTIVE_HIGH, NULL}, \
           {PWM_COMPLEMENTARY_OUTPUT_ACTIVE_HIGH, NULL}, \
           {PWM_OUTPUT_DISABLED, NULL}  \
          }, 0, 0}, &PWMD1, 1, \
          HAL_PWM1_DMA_CONFIG, \
          { 1, 1, 1, 0 }, \
          { PAL_LINE(GPIOA,8U), PAL_LINE(GPIOB,0U), PAL_LINE(GPIOB,1U), 0 }}
#define HAL_PWM_GROUPS HAL_PWM_GROUP1,HAL_PWM_GROUP2,HAL_PWM_GROUP3

#define STM32_PWM_USE_ADVANCED TRUE
// I2C configuration

#if defined(STM32_I2C_I2C2_RX_DMA_STREAM) && defined(STM32_I2C_I2C2_TX_DMA_STREAM)
#define HAL_I2C2_CONFIG { &I2CD2, 2, STM32_I2C_I2C2_RX_DMA_STREAM, STM32_I2C_I2C2_TX_DMA_STREAM, PAL_LINE(GPIOB,10U), PAL_LINE(GPIOB,11U) }
#else
#define HAL_I2C2_CONFIG { &I2CD2, 2, SHARED_DMA_NONE, SHARED_DMA_NONE, PAL_LINE(GPIOB,10U), PAL_LINE(GPIOB,11U) }
#endif

#define HAL_I2C_DEVICE_LIST HAL_I2C2_CONFIG


// UART configuration
#define HAL_HAVE_SERIAL0 1
#define HAL_HAVE_SERIAL1 1
#define HAL_HAVE_SERIAL2 1
#define HAL_HAVE_SERIAL3 1
#define HAL_HAVE_SERIAL4 1
#define HAL_NUM_SERIAL_PORTS 5
#define HAL_SERIAL0_DRIVER ChibiOS::UARTDriver serial0Driver(0)
#define HAL_SERIAL1_DRIVER ChibiOS::UARTDriver serial1Driver(1)
#define HAL_SERIAL2_DRIVER ChibiOS::UARTDriver serial2Driver(2)
#define HAL_SERIAL3_DRIVER ChibiOS::UARTDriver serial3Driver(3)
#define HAL_SERIAL4_DRIVER ChibiOS::UARTDriver serial4Driver(4)
#define HAL_SERIAL5_DRIVER Empty::UARTDriver serial5Driver
#define HAL_SERIAL6_DRIVER Empty::UARTDriver serial6Driver
#define HAL_SERIAL7_DRIVER Empty::UARTDriver serial7Driver
#define HAL_SERIAL8_DRIVER Empty::UARTDriver serial8Driver
#define HAL_SERIAL9_DRIVER Empty::UARTDriver serial9Driver
#define HAL_WITH_IO_MCU 0

#define HAL_OTG1_CONFIG {(BaseSequentialStream*) &SDU1, 1, true, false, 0, 0, false, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, UINT8_MAX,}
#define HAL_USART1_CONFIG { (BaseSequentialStream*) &SD1, 1, false, STM32_USART1_RX_DMA_CONFIG, STM32_USART1_TX_DMA_CONFIG, PAL_LINE(GPIOA,9U), PAL_LINE(GPIOA,10U), 0, 0, -1, 0, -1, 0, 0, UINT8_MAX}
#define HAL_USART3_CONFIG { (BaseSequentialStream*) &SD3, 3, false, STM32_USART3_RX_DMA_CONFIG, STM32_USART3_TX_DMA_CONFIG, 0, 0, 0, 0, -1, 0, -1, 0, 0, UINT8_MAX}
#define HAL_USART6_CONFIG { (BaseSequentialStream*) &SD6, 6, false, STM32_USART6_RX_DMA_CONFIG, STM32_USART6_TX_DMA_CONFIG, PAL_LINE(GPIOC,6U), PAL_LINE(GPIOC,7U), 0, 0, -1, 0, -1, 0, 0, UINT8_MAX}
#define HAL_UART4_CONFIG { (BaseSequentialStream*) &SD4, 4, false, STM32_UART4_RX_DMA_CONFIG, STM32_UART4_TX_DMA_CONFIG, 0, 0, 0, 0, -1, 0, -1, 0, 0, UINT8_MAX}
#define HAL_SERIAL_DEVICE_LIST HAL_OTG1_CONFIG,HAL_USART1_CONFIG,HAL_USART3_CONFIG,HAL_USART6_CONFIG,HAL_UART4_CONFIG

#define HAL_UART_NUM_SERIAL_PORTS 5
// USB configuration
#define HAL_USB_VENDOR_ID 0x1209
#define HAL_USB_PRODUCT_ID 0x5741
#define HAL_USB_STRING_MANUFACTURER "ArduPilot"
#define HAL_USB_STRING_PRODUCT "%BOARD%"
#define HAL_USB_STRING_SERIAL "%SERIAL%"



/*
* I/O ports initial setup, this configuration is established soon after reset
* in the initialization code.
* Please refer to the STM32 Reference Manual for details.
*/
#define PIN_MODE_INPUT(n)           (0U << ((n) * 2U))
#define PIN_MODE_OUTPUT(n)          (1U << ((n) * 2U))
#define PIN_MODE_ALTERNATE(n)       (2U << ((n) * 2U))
#define PIN_MODE_ANALOG(n)          (3U << ((n) * 2U))
#define PIN_ODR_LOW(n)              (0U << (n))
#define PIN_ODR_HIGH(n)             (1U << (n))
#define PIN_OTYPE_PUSHPULL(n)       (0U << (n))
#define PIN_OTYPE_OPENDRAIN(n)      (1U << (n))
#define PIN_OSPEED_VERYLOW(n)       (0U << ((n) * 2U))
#define PIN_OSPEED_LOW(n)           (1U << ((n) * 2U))
#define PIN_OSPEED_MEDIUM(n)        (2U << ((n) * 2U))
#define PIN_OSPEED_HIGH(n)          (3U << ((n) * 2U))
#define PIN_PUPDR_FLOATING(n)       (0U << ((n) * 2U))
#define PIN_PUPDR_PULLUP(n)         (1U << ((n) * 2U))
#define PIN_PUPDR_PULLDOWN(n)       (2U << ((n) * 2U))
#define PIN_AFIO_AF(n, v)           ((v) << (((n) % 8U) * 4U))

/* PORTA:
 PA0 RSSI_IN ADC1 ADC1_IN0
 PA1 TIM2_CH2 TIM2 AF1 PWM5
 PA2 TIM2_CH3 TIM2 AF1 PWM4
 PA3 TIM2_CH4 TIM2 AF1 PWM3
 PA4 MPU6000_CS CS
 PA5 SPI1_SCK SPI1 AF5
 PA6 SPI1_MISO SPI1 AF5
 PA7 SPI1_MOSI SPI1 AF5
 PA8 TIM1_CH1 TIM1 AF1 PWM6
 PA9 USART1_TX USART1 AF7
 PA10 USART1_RX USART1 AF7
 PA11 OTG_FS_DM OTG1 AF10
 PA12 OTG_FS_DP OTG1 AF10
 PA13 JTMS-SWDIO SWD AF0
 PA14 JTCK-SWCLK SWD AF0
 PA15 OSD_CS CS
*/

#define VAL_GPIOA_MODER   (PIN_MODE_ANALOG(0U) | \
                           PIN_MODE_ALTERNATE(1U) | \
                           PIN_MODE_ALTERNATE(2U) | \
                           PIN_MODE_ALTERNATE(3U) | \
                           PIN_MODE_OUTPUT(4U) | \
                           PIN_MODE_ALTERNATE(5U) | \
                           PIN_MODE_ALTERNATE(6U) | \
                           PIN_MODE_ALTERNATE(7U) | \
                           PIN_MODE_ALTERNATE(8U) | \
                           PIN_MODE_ALTERNATE(9U) | \
                           PIN_MODE_ALTERNATE(10U) | \
                           PIN_MODE_ALTERNATE(11U) | \
                           PIN_MODE_ALTERNATE(12U) | \
                           PIN_MODE_ALTERNATE(13U) | \
                           PIN_MODE_ALTERNATE(14U) | \
                           PIN_MODE_OUTPUT(15U))

#define VAL_GPIOA_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_PUSHPULL(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_PUSHPULL(10U) | \
                           PIN_OTYPE_PUSHPULL(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOA_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOA_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_FLOATING(3U) | \
                           PIN_PUPDR_PULLUP(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_FLOATING(6U) | \
                           PIN_PUPDR_FLOATING(7U) | \
                           PIN_PUPDR_FLOATING(8U) | \
                           PIN_PUPDR_PULLUP(9U) | \
                           PIN_PUPDR_PULLUP(10U) | \
                           PIN_PUPDR_FLOATING(11U) | \
                           PIN_PUPDR_FLOATING(12U) | \
                           PIN_PUPDR_PULLUP(13U) | \
                           PIN_PUPDR_PULLDOWN(14U) | \
                           PIN_PUPDR_PULLUP(15U))

#define VAL_GPIOA_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_HIGH(4U) | \
                           PIN_ODR_HIGH(5U) | \
                           PIN_ODR_HIGH(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_HIGH(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOA_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 1U) | \
                           PIN_AFIO_AF(2U, 1U) | \
                           PIN_AFIO_AF(3U, 1U) | \
                           PIN_AFIO_AF(4U, 0U) | \
                           PIN_AFIO_AF(5U, 5U) | \
                           PIN_AFIO_AF(6U, 5U) | \
                           PIN_AFIO_AF(7U, 5U))

#define VAL_GPIOA_AFRH    (PIN_AFIO_AF(8U, 1U) | \
                           PIN_AFIO_AF(9U, 7U) | \
                           PIN_AFIO_AF(10U, 7U) | \
                           PIN_AFIO_AF(11U, 10U) | \
                           PIN_AFIO_AF(12U, 10U) | \
                           PIN_AFIO_AF(13U, 0U) | \
                           PIN_AFIO_AF(14U, 0U) | \
                           PIN_AFIO_AF(15U, 0U))

/* PORTB:
 PB0 TIM1_CH2N TIM1 AF1 PWM1
 PB1 TIM1_CH3N TIM1 AF1 PWM2
 PB3 BMP280_CS CS
 PB4 TIM3_CH1 TIM3 AF2
 PB5 LED_BLUE OUTPUT
 PB6 GP_GPIO OUTPUT
 PB8 TIM4_CH3 TIM4 AF2
 PB10 I2C2_SCL I2C2 AF4
 PB11 I2C2_SDA I2C2 AF4
 PB12 SDCARD_CS CS
 PB13 SPI2_SCK SPI2 AF5
 PB14 SPI2_MISO SPI2 AF5
 PB15 SPI2_MOSI SPI2 AF5
*/

#define VAL_GPIOB_MODER   (PIN_MODE_ALTERNATE(0U) | \
                           PIN_MODE_ALTERNATE(1U) | \
                           PIN_MODE_INPUT(2U) | \
                           PIN_MODE_OUTPUT(3U) | \
                           PIN_MODE_ALTERNATE(4U) | \
                           PIN_MODE_OUTPUT(5U) | \
                           PIN_MODE_OUTPUT(6U) | \
                           PIN_MODE_INPUT(7U) | \
                           PIN_MODE_ALTERNATE(8U) | \
                           PIN_MODE_INPUT(9U) | \
                           PIN_MODE_ALTERNATE(10U) | \
                           PIN_MODE_ALTERNATE(11U) | \
                           PIN_MODE_OUTPUT(12U) | \
                           PIN_MODE_ALTERNATE(13U) | \
                           PIN_MODE_ALTERNATE(14U) | \
                           PIN_MODE_ALTERNATE(15U))

#define VAL_GPIOB_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_PUSHPULL(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_OPENDRAIN(10U) | \
                           PIN_OTYPE_OPENDRAIN(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOB_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOB_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_PULLUP(3U) | \
                           PIN_PUPDR_FLOATING(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_FLOATING(6U) | \
                           PIN_PUPDR_FLOATING(7U) | \
                           PIN_PUPDR_PULLDOWN(8U) | \
                           PIN_PUPDR_FLOATING(9U) | \
                           PIN_PUPDR_PULLUP(10U) | \
                           PIN_PUPDR_PULLUP(11U) | \
                           PIN_PUPDR_PULLUP(12U) | \
                           PIN_PUPDR_FLOATING(13U) | \
                           PIN_PUPDR_FLOATING(14U) | \
                           PIN_PUPDR_FLOATING(15U))

#define VAL_GPIOB_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_LOW(4U) | \
                           PIN_ODR_LOW(5U) | \
                           PIN_ODR_LOW(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_LOW(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOB_AFRL    (PIN_AFIO_AF(0U, 1U) | \
                           PIN_AFIO_AF(1U, 1U) | \
                           PIN_AFIO_AF(2U, 0U) | \
                           PIN_AFIO_AF(3U, 0U) | \
                           PIN_AFIO_AF(4U, 2U) | \
                           PIN_AFIO_AF(5U, 0U) | \
                           PIN_AFIO_AF(6U, 0U) | \
                           PIN_AFIO_AF(7U, 0U))

#define VAL_GPIOB_AFRH    (PIN_AFIO_AF(8U, 2U) | \
                           PIN_AFIO_AF(9U, 0U) | \
                           PIN_AFIO_AF(10U, 4U) | \
                           PIN_AFIO_AF(11U, 4U) | \
                           PIN_AFIO_AF(12U, 0U) | \
                           PIN_AFIO_AF(13U, 5U) | \
                           PIN_AFIO_AF(14U, 5U) | \
                           PIN_AFIO_AF(15U, 5U))

/* PORTC:
 PC1 BAT_CURR_SENS ADC1 ADC1_IN11
 PC2 BAT_VOLT_SENS ADC1 ADC1_IN12
 PC5 VBUS INPUT
 PC6 USART6_TX USART6 AF8
 PC7 USART6_RX USART6 AF8
 PC8 TIM8_CH3 TIM8 AF3 PWM7
 PC9 TIM8_CH4 TIM8 AF3 PWM8
 PC10 SPI3_SCK SPI3 AF6
 PC11 SPI3_MISO SPI3 AF6
 PC12 SPI3_MOSI SPI3 AF6
*/

#define VAL_GPIOC_MODER   (PIN_MODE_INPUT(0U) | \
                           PIN_MODE_ANALOG(1U) | \
                           PIN_MODE_ANALOG(2U) | \
                           PIN_MODE_INPUT(3U) | \
                           PIN_MODE_INPUT(4U) | \
                           PIN_MODE_INPUT(5U) | \
                           PIN_MODE_ALTERNATE(6U) | \
                           PIN_MODE_ALTERNATE(7U) | \
                           PIN_MODE_ALTERNATE(8U) | \
                           PIN_MODE_ALTERNATE(9U) | \
                           PIN_MODE_ALTERNATE(10U) | \
                           PIN_MODE_ALTERNATE(11U) | \
                           PIN_MODE_ALTERNATE(12U) | \
                           PIN_MODE_INPUT(13U) | \
                           PIN_MODE_INPUT(14U) | \
                           PIN_MODE_INPUT(15U))

#define VAL_GPIOC_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_OPENDRAIN(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_PUSHPULL(10U) | \
                           PIN_OTYPE_PUSHPULL(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOC_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOC_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_FLOATING(3U) | \
                           PIN_PUPDR_FLOATING(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_PULLUP(6U) | \
                           PIN_PUPDR_PULLUP(7U) | \
                           PIN_PUPDR_FLOATING(8U) | \
                           PIN_PUPDR_FLOATING(9U) | \
                           PIN_PUPDR_FLOATING(10U) | \
                           PIN_PUPDR_FLOATING(11U) | \
                           PIN_PUPDR_FLOATING(12U) | \
                           PIN_PUPDR_FLOATING(13U) | \
                           PIN_PUPDR_FLOATING(14U) | \
                           PIN_PUPDR_FLOATING(15U))

#define VAL_GPIOC_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_HIGH(4U) | \
                           PIN_ODR_HIGH(5U) | \
                           PIN_ODR_HIGH(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_HIGH(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOC_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 0U) | \
                           PIN_AFIO_AF(2U, 0U) | \
                           PIN_AFIO_AF(3U, 0U) | \
                           PIN_AFIO_AF(4U, 0U) | \
                           PIN_AFIO_AF(5U, 0U) | \
                           PIN_AFIO_AF(6U, 8U) | \
                           PIN_AFIO_AF(7U, 8U))

#define VAL_GPIOC_AFRH    (PIN_AFIO_AF(8U, 3U) | \
                           PIN_AFIO_AF(9U, 3U) | \
                           PIN_AFIO_AF(10U, 6U) | \
                           PIN_AFIO_AF(11U, 6U) | \
                           PIN_AFIO_AF(12U, 6U) | \
                           PIN_AFIO_AF(13U, 0U) | \
                           PIN_AFIO_AF(14U, 0U) | \
                           PIN_AFIO_AF(15U, 0U))

/* PORTD:
*/

#define VAL_GPIOD_MODER   (PIN_MODE_INPUT(0U) | \
                           PIN_MODE_INPUT(1U) | \
                           PIN_MODE_INPUT(2U) | \
                           PIN_MODE_INPUT(3U) | \
                           PIN_MODE_INPUT(4U) | \
                           PIN_MODE_INPUT(5U) | \
                           PIN_MODE_INPUT(6U) | \
                           PIN_MODE_INPUT(7U) | \
                           PIN_MODE_INPUT(8U) | \
                           PIN_MODE_INPUT(9U) | \
                           PIN_MODE_INPUT(10U) | \
                           PIN_MODE_INPUT(11U) | \
                           PIN_MODE_INPUT(12U) | \
                           PIN_MODE_INPUT(13U) | \
                           PIN_MODE_INPUT(14U) | \
                           PIN_MODE_INPUT(15U))

#define VAL_GPIOD_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_PUSHPULL(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_PUSHPULL(10U) | \
                           PIN_OTYPE_PUSHPULL(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOD_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOD_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_FLOATING(3U) | \
                           PIN_PUPDR_FLOATING(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_FLOATING(6U) | \
                           PIN_PUPDR_FLOATING(7U) | \
                           PIN_PUPDR_FLOATING(8U) | \
                           PIN_PUPDR_FLOATING(9U) | \
                           PIN_PUPDR_FLOATING(10U) | \
                           PIN_PUPDR_FLOATING(11U) | \
                           PIN_PUPDR_FLOATING(12U) | \
                           PIN_PUPDR_FLOATING(13U) | \
                           PIN_PUPDR_FLOATING(14U) | \
                           PIN_PUPDR_FLOATING(15U))

#define VAL_GPIOD_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_HIGH(4U) | \
                           PIN_ODR_HIGH(5U) | \
                           PIN_ODR_HIGH(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_HIGH(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOD_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 0U) | \
                           PIN_AFIO_AF(2U, 0U) | \
                           PIN_AFIO_AF(3U, 0U) | \
                           PIN_AFIO_AF(4U, 0U) | \
                           PIN_AFIO_AF(5U, 0U) | \
                           PIN_AFIO_AF(6U, 0U) | \
                           PIN_AFIO_AF(7U, 0U))

#define VAL_GPIOD_AFRH    (PIN_AFIO_AF(8U, 0U) | \
                           PIN_AFIO_AF(9U, 0U) | \
                           PIN_AFIO_AF(10U, 0U) | \
                           PIN_AFIO_AF(11U, 0U) | \
                           PIN_AFIO_AF(12U, 0U) | \
                           PIN_AFIO_AF(13U, 0U) | \
                           PIN_AFIO_AF(14U, 0U) | \
                           PIN_AFIO_AF(15U, 0U))

/* PORTE:
*/

#define VAL_GPIOE_MODER   (PIN_MODE_INPUT(0U) | \
                           PIN_MODE_INPUT(1U) | \
                           PIN_MODE_INPUT(2U) | \
                           PIN_MODE_INPUT(3U) | \
                           PIN_MODE_INPUT(4U) | \
                           PIN_MODE_INPUT(5U) | \
                           PIN_MODE_INPUT(6U) | \
                           PIN_MODE_INPUT(7U) | \
                           PIN_MODE_INPUT(8U) | \
                           PIN_MODE_INPUT(9U) | \
                           PIN_MODE_INPUT(10U) | \
                           PIN_MODE_INPUT(11U) | \
                           PIN_MODE_INPUT(12U) | \
                           PIN_MODE_INPUT(13U) | \
                           PIN_MODE_INPUT(14U) | \
                           PIN_MODE_INPUT(15U))

#define VAL_GPIOE_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_PUSHPULL(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_PUSHPULL(10U) | \
                           PIN_OTYPE_PUSHPULL(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOE_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOE_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_FLOATING(3U) | \
                           PIN_PUPDR_FLOATING(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_FLOATING(6U) | \
                           PIN_PUPDR_FLOATING(7U) | \
                           PIN_PUPDR_FLOATING(8U) | \
                           PIN_PUPDR_FLOATING(9U) | \
                           PIN_PUPDR_FLOATING(10U) | \
                           PIN_PUPDR_FLOATING(11U) | \
                           PIN_PUPDR_FLOATING(12U) | \
                           PIN_PUPDR_FLOATING(13U) | \
                           PIN_PUPDR_FLOATING(14U) | \
                           PIN_PUPDR_FLOATING(15U))

#define VAL_GPIOE_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_HIGH(4U) | \
                           PIN_ODR_HIGH(5U) | \
                           PIN_ODR_HIGH(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_HIGH(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOE_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 0U) | \
                           PIN_AFIO_AF(2U, 0U) | \
                           PIN_AFIO_AF(3U, 0U) | \
                           PIN_AFIO_AF(4U, 0U) | \
                           PIN_AFIO_AF(5U, 0U) | \
                           PIN_AFIO_AF(6U, 0U) | \
                           PIN_AFIO_AF(7U, 0U))

#define VAL_GPIOE_AFRH    (PIN_AFIO_AF(8U, 0U) | \
                           PIN_AFIO_AF(9U, 0U) | \
                           PIN_AFIO_AF(10U, 0U) | \
                           PIN_AFIO_AF(11U, 0U) | \
                           PIN_AFIO_AF(12U, 0U) | \
                           PIN_AFIO_AF(13U, 0U) | \
                           PIN_AFIO_AF(14U, 0U) | \
                           PIN_AFIO_AF(15U, 0U))

/* PORTF:
*/

#define VAL_GPIOF_MODER   (PIN_MODE_INPUT(0U) | \
                           PIN_MODE_INPUT(1U) | \
                           PIN_MODE_INPUT(2U) | \
                           PIN_MODE_INPUT(3U) | \
                           PIN_MODE_INPUT(4U) | \
                           PIN_MODE_INPUT(5U) | \
                           PIN_MODE_INPUT(6U) | \
                           PIN_MODE_INPUT(7U) | \
                           PIN_MODE_INPUT(8U) | \
                           PIN_MODE_INPUT(9U) | \
                           PIN_MODE_INPUT(10U) | \
                           PIN_MODE_INPUT(11U) | \
                           PIN_MODE_INPUT(12U) | \
                           PIN_MODE_INPUT(13U) | \
                           PIN_MODE_INPUT(14U) | \
                           PIN_MODE_INPUT(15U))

#define VAL_GPIOF_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_PUSHPULL(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_PUSHPULL(10U) | \
                           PIN_OTYPE_PUSHPULL(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOF_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOF_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_FLOATING(3U) | \
                           PIN_PUPDR_FLOATING(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_FLOATING(6U) | \
                           PIN_PUPDR_FLOATING(7U) | \
                           PIN_PUPDR_FLOATING(8U) | \
                           PIN_PUPDR_FLOATING(9U) | \
                           PIN_PUPDR_FLOATING(10U) | \
                           PIN_PUPDR_FLOATING(11U) | \
                           PIN_PUPDR_FLOATING(12U) | \
                           PIN_PUPDR_FLOATING(13U) | \
                           PIN_PUPDR_FLOATING(14U) | \
                           PIN_PUPDR_FLOATING(15U))

#define VAL_GPIOF_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_HIGH(4U) | \
                           PIN_ODR_HIGH(5U) | \
                           PIN_ODR_HIGH(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_HIGH(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOF_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 0U) | \
                           PIN_AFIO_AF(2U, 0U) | \
                           PIN_AFIO_AF(3U, 0U) | \
                           PIN_AFIO_AF(4U, 0U) | \
                           PIN_AFIO_AF(5U, 0U) | \
                           PIN_AFIO_AF(6U, 0U) | \
                           PIN_AFIO_AF(7U, 0U))

#define VAL_GPIOF_AFRH    (PIN_AFIO_AF(8U, 0U) | \
                           PIN_AFIO_AF(9U, 0U) | \
                           PIN_AFIO_AF(10U, 0U) | \
                           PIN_AFIO_AF(11U, 0U) | \
                           PIN_AFIO_AF(12U, 0U) | \
                           PIN_AFIO_AF(13U, 0U) | \
                           PIN_AFIO_AF(14U, 0U) | \
                           PIN_AFIO_AF(15U, 0U))

/* PORTG:
*/

#define VAL_GPIOG_MODER   (PIN_MODE_INPUT(0U) | \
                           PIN_MODE_INPUT(1U) | \
                           PIN_MODE_INPUT(2U) | \
                           PIN_MODE_INPUT(3U) | \
                           PIN_MODE_INPUT(4U) | \
                           PIN_MODE_INPUT(5U) | \
                           PIN_MODE_INPUT(6U) | \
                           PIN_MODE_INPUT(7U) | \
                           PIN_MODE_INPUT(8U) | \
                           PIN_MODE_INPUT(9U) | \
                           PIN_MODE_INPUT(10U) | \
                           PIN_MODE_INPUT(11U) | \
                           PIN_MODE_INPUT(12U) | \
                           PIN_MODE_INPUT(13U) | \
                           PIN_MODE_INPUT(14U) | \
                           PIN_MODE_INPUT(15U))

#define VAL_GPIOG_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U) | \
                           PIN_OTYPE_PUSHPULL(2U) | \
                           PIN_OTYPE_PUSHPULL(3U) | \
                           PIN_OTYPE_PUSHPULL(4U) | \
                           PIN_OTYPE_PUSHPULL(5U) | \
                           PIN_OTYPE_PUSHPULL(6U) | \
                           PIN_OTYPE_PUSHPULL(7U) | \
                           PIN_OTYPE_PUSHPULL(8U) | \
                           PIN_OTYPE_PUSHPULL(9U) | \
                           PIN_OTYPE_PUSHPULL(10U) | \
                           PIN_OTYPE_PUSHPULL(11U) | \
                           PIN_OTYPE_PUSHPULL(12U) | \
                           PIN_OTYPE_PUSHPULL(13U) | \
                           PIN_OTYPE_PUSHPULL(14U) | \
                           PIN_OTYPE_PUSHPULL(15U))

#define VAL_GPIOG_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U) | \
                           PIN_OSPEED_MEDIUM(2U) | \
                           PIN_OSPEED_MEDIUM(3U) | \
                           PIN_OSPEED_MEDIUM(4U) | \
                           PIN_OSPEED_MEDIUM(5U) | \
                           PIN_OSPEED_MEDIUM(6U) | \
                           PIN_OSPEED_MEDIUM(7U) | \
                           PIN_OSPEED_MEDIUM(8U) | \
                           PIN_OSPEED_MEDIUM(9U) | \
                           PIN_OSPEED_MEDIUM(10U) | \
                           PIN_OSPEED_MEDIUM(11U) | \
                           PIN_OSPEED_MEDIUM(12U) | \
                           PIN_OSPEED_MEDIUM(13U) | \
                           PIN_OSPEED_MEDIUM(14U) | \
                           PIN_OSPEED_MEDIUM(15U))

#define VAL_GPIOG_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U) | \
                           PIN_PUPDR_FLOATING(2U) | \
                           PIN_PUPDR_FLOATING(3U) | \
                           PIN_PUPDR_FLOATING(4U) | \
                           PIN_PUPDR_FLOATING(5U) | \
                           PIN_PUPDR_FLOATING(6U) | \
                           PIN_PUPDR_FLOATING(7U) | \
                           PIN_PUPDR_FLOATING(8U) | \
                           PIN_PUPDR_FLOATING(9U) | \
                           PIN_PUPDR_FLOATING(10U) | \
                           PIN_PUPDR_FLOATING(11U) | \
                           PIN_PUPDR_FLOATING(12U) | \
                           PIN_PUPDR_FLOATING(13U) | \
                           PIN_PUPDR_FLOATING(14U) | \
                           PIN_PUPDR_FLOATING(15U))

#define VAL_GPIOG_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U) | \
                           PIN_ODR_HIGH(2U) | \
                           PIN_ODR_HIGH(3U) | \
                           PIN_ODR_HIGH(4U) | \
                           PIN_ODR_HIGH(5U) | \
                           PIN_ODR_HIGH(6U) | \
                           PIN_ODR_HIGH(7U) | \
                           PIN_ODR_HIGH(8U) | \
                           PIN_ODR_HIGH(9U) | \
                           PIN_ODR_HIGH(10U) | \
                           PIN_ODR_HIGH(11U) | \
                           PIN_ODR_HIGH(12U) | \
                           PIN_ODR_HIGH(13U) | \
                           PIN_ODR_HIGH(14U) | \
                           PIN_ODR_HIGH(15U))

#define VAL_GPIOG_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 0U) | \
                           PIN_AFIO_AF(2U, 0U) | \
                           PIN_AFIO_AF(3U, 0U) | \
                           PIN_AFIO_AF(4U, 0U) | \
                           PIN_AFIO_AF(5U, 0U) | \
                           PIN_AFIO_AF(6U, 0U) | \
                           PIN_AFIO_AF(7U, 0U))

#define VAL_GPIOG_AFRH    (PIN_AFIO_AF(8U, 0U) | \
                           PIN_AFIO_AF(9U, 0U) | \
                           PIN_AFIO_AF(10U, 0U) | \
                           PIN_AFIO_AF(11U, 0U) | \
                           PIN_AFIO_AF(12U, 0U) | \
                           PIN_AFIO_AF(13U, 0U) | \
                           PIN_AFIO_AF(14U, 0U) | \
                           PIN_AFIO_AF(15U, 0U))

/* PORTH:
*/

#define VAL_GPIOH_MODER   (PIN_MODE_INPUT(0U) | \
                           PIN_MODE_INPUT(1U))

#define VAL_GPIOH_OTYPER  (PIN_OTYPE_PUSHPULL(0U) | \
                           PIN_OTYPE_PUSHPULL(1U))

#define VAL_GPIOH_OSPEEDR (PIN_OSPEED_MEDIUM(0U) | \
                           PIN_OSPEED_MEDIUM(1U))

#define VAL_GPIOH_PUPDR   (PIN_PUPDR_FLOATING(0U) | \
                           PIN_PUPDR_FLOATING(1U))

#define VAL_GPIOH_ODR     (PIN_ODR_HIGH(0U) | \
                           PIN_ODR_HIGH(1U))

#define VAL_GPIOH_AFRL    (PIN_AFIO_AF(0U, 0U) | \
                           PIN_AFIO_AF(1U, 0U))

#define VAL_GPIOH_AFRH    (0)

/* PORTI:
*/

#define VAL_GPIOI_MODER               0x0
#define VAL_GPIOI_OTYPER              0x0
#define VAL_GPIOI_OSPEEDR             0x0
#define VAL_GPIOI_PUPDR               0x0
#define VAL_GPIOI_ODR                 0x0
#define VAL_GPIOI_AFRL                0x0
#define VAL_GPIOI_AFRH                0x0



/* PORTJ:
*/

#define VAL_GPIOJ_MODER               0x0
#define VAL_GPIOJ_OTYPER              0x0
#define VAL_GPIOJ_OSPEEDR             0x0
#define VAL_GPIOJ_PUPDR               0x0
#define VAL_GPIOJ_ODR                 0x0
#define VAL_GPIOJ_AFRL                0x0
#define VAL_GPIOJ_AFRH                0x0



/* PORTK:
*/

#define VAL_GPIOK_MODER               0x0
#define VAL_GPIOK_OTYPER              0x0
#define VAL_GPIOK_OSPEEDR             0x0
#define VAL_GPIOK_PUPDR               0x0
#define VAL_GPIOK_ODR                 0x0
#define VAL_GPIOK_AFRL                0x0
#define VAL_GPIOK_AFRH                0x0




/* alternative configurations */
#define PAL_STM32_SPEED(n) ((n&3U)<<3U)
#define PAL_STM32_HIGH     0x8000U

#define HAL_PIN_ALT_CONFIG { \
    { 1, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(7), PAL_LINE(GPIOB,10U), PERIPH_TYPE::UART_TX, 3}, /* PB10 USART3_TX USART3 AF7 */ \
    { 1, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(7), PAL_LINE(GPIOB,11U), PERIPH_TYPE::UART_RX, 3}, /* PB11 USART3_RX USART3 AF7 */ \
    { 2, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(8), PAL_LINE(GPIOA,0U), PERIPH_TYPE::UART_TX, 4}, /* PA0 UART4_TX UART4 AF8 */ \
    { 3, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(8), PAL_LINE(GPIOA,0U), PERIPH_TYPE::UART_TX, 4}, /* PA0 UART4_TX UART4 AF8 */ \
    { 3, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(8), PAL_LINE(GPIOA,1U), PERIPH_TYPE::UART_RX, 4}, /* PA1 UART4_RX UART4 AF8 */ \
    { 4, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(8), PAL_LINE(GPIOA,0U), PERIPH_TYPE::UART_TX, 4}, /* PA0 UART4_TX UART4 AF8 */ \
    { 4, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(8), PAL_LINE(GPIOA,1U), PERIPH_TYPE::UART_RX, 4}, /* PA1 UART4_RX UART4 AF8 */ \
    { 4, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(7), PAL_LINE(GPIOB,10U), PERIPH_TYPE::UART_TX, 3}, /* PB10 USART3_TX USART3 AF7 */ \
    { 4, PAL_STM32_MODE_ALTERNATE|PAL_STM32_OTYPE_PUSHPULL|PAL_STM32_SPEED(2)|PAL_STM32_PUPDR_PULLUP|PAL_STM32_ALTERNATE(7), PAL_LINE(GPIOB,11U), PERIPH_TYPE::UART_RX, 3}, /* PB11 USART3_RX USART3 AF7 */ \
}


// normal defaults

// this file is inserted (by chibios_hwdef.py) into hwdef.h when
// configuring for "normal" builds - typically vehicle binaries but
// also examples.

#ifndef HAL_DSHOT_ALARM_ENABLED
#define HAL_DSHOT_ALARM_ENABLED (HAL_PWM_COUNT>0)
#endif

#ifndef HAL_BOARD_LOG_DIRECTORY
#define HAL_BOARD_LOG_DIRECTORY "/APM/LOGS"
#endif

// a similar define is present in AP_HAL_Boards.h:
#ifndef HAL_OS_FATFS_IO
#define HAL_OS_FATFS_IO 0
#endif

#ifndef AP_TERRAIN_AVAILABLE
// enable terrain only if there's an SD card available:
#define AP_TERRAIN_AVAILABLE HAL_OS_FATFS_IO
#endif

#if AP_TERRAIN_AVAILABLE
#ifndef HAL_BOARD_TERRAIN_DIRECTORY
#define HAL_BOARD_TERRAIN_DIRECTORY "/APM/TERRAIN"
#endif
#endif  // AP_TERRAIN_AVAILABLE


// end normal defaults
